IF EXISTS (SELECT * FROM SYS.TRIGGERS WHERE NAME = 'TRG_PDV_VD_IT_FIDELI_CARTAO') 
BEGIN
	DROP TRIGGER TRG_PDV_VD_IT_FIDELI_CARTAO;
END
GO

CREATE TRIGGER [dbo].[TRG_PDV_VD_IT_FIDELI_CARTAO] ON [dbo].[PDV_VD_IT_FIDELI_CARTAO] FOR insert AS
begin	

	DECLARE @TP_CONSLD  AS INT
	DECLARE @CD_CTR     AS INT 
	DECLARE @CD_EMP		INT
	DECLARE @CD_FILIAL	INT
	DECLARE @CD_CLI		INT
	DECLARE @QTDE_PONTOS  MONEY
	DECLARE @DT_CAD		DATETIME
	DECLARE @CD_USU		INT 
	DECLARE @CD_VD		INT 
	DECLARE @CD_IT		INT
	
	IF EXISTS (SELECT * FROM PRC_EMP_CONFIG WHERE CD_EMP = 1 AND CD_CHAVE = 'FLAG_IGNORA_CONTROLE_CREDITO_DEBITO_PONTOS_FIDEL' AND VALOR = 1)
	BEGIN
		RETURN;
	END
	
	IF EXISTS (SELECT * 
					FROM 
						PRC_FILIAL_CONFIG 
					WHERE 
						CD_EMP = 1 
						AND CD_CHAVE = 'TP_INTEGRACAO_FIDEL' 
						AND VALOR = '0'
						AND CD_FILIAL = (SELECT TOP 1 CD_FILIAL FROM INSERTED) )
	BEGIN 
		RETURN;
	END

	IF EXISTS (SELECT top 1 p.CD_CLI FROM PDV_VD p INNER JOIN INSERTED i ON
					p.CD_EMP = i.CD_EMP
					AND p.CD_FILIAL = i.CD_FILIAL
					AND p.CD_VD = i.CD_VD
							
					INNER JOIN RC_CLI C ON
					C.CD_EMP=P.CD_EMP AND
					C.CD_CLI = P.CD_CLI
				WHERE CONS_FINAL=1 OR TP_CONS_FINAL=1)	
		BEGIN
			RETURN;
		END

BEGIN TRY 
	
	/*****************************************************************************************************************************/
	/*****************************************************************************************************************************/	  
	/* INSERINDO CREDITOS */
	/*****************************************************************************************************************************/
	/*****************************************************************************************************************************/
	IF EXISTS (SELECT   *
						FROM
							 PDV_VD p
							 INNER JOIN INSERTED i ON p.CD_EMP = i.CD_EMP
													  AND p.CD_FILIAL = i.CD_FILIAL
													  AND p.CD_VD = i.CD_VD
						WHERE P.CD_EMP = 1
							  AND ISNULL(p.VD_TROCA_FIDEL, 0) = 0)
	BEGIN			

		DECLARE GerarPontos CURSOR FAST_FORWARD FOR 
		SELECT
				v.CD_EMP
				, v.CD_FILIAL
				, v.CD_CLI
				, i.VLR_PONTO_IT
				, v.DT_VD
				, v.CD_USU
				, v.CD_VD
				, i.CD_IT
		FROM
				INSERTED i
				INNER JOIN PDV_VD v ON i.CD_EMP = v.CD_EMP
									AND i.CD_FILIAL = v.CD_FILIAL
									AND i.CD_VD = v.CD_VD
									AND i.ENVIO_FIDEL = 0
									AND v.VD_TROCA_FIDEL = 0;

	   OPEN GerarPontos
	   FETCH NEXT FROM GerarPontos INTO  @CD_EMP,@CD_FILIAL,@CD_CLI,@QTDE_PONTOS,@DT_CAD,@CD_USU, @CD_VD, @CD_IT

	   WHILE @@FETCH_STATUS = 0 
	   BEGIN	

			INSERT INTO RC_CLI_FIDELI_PONTOS_CREDITO  (CD_EMP, CD_CLI, QTDE_PONTOS, DT_CAD, CD_USU, CD_MT_PONTO, DT_CAD_REGISTRO)
			SELECT
				   @CD_EMP
				 , @CD_CLI
				 , @QTDE_PONTOS
				 , @DT_CAD
				 , @CD_USU
				 , 0 AS CD_MT_PONTO
				 , GETDATE();

			--Inserindo relacionamento de vendas como a pontuacao
			INSERT INTO RC_CLI_FIDELI_PONTOS_CREDITO_PDV_VD_IT_FIDELI_CARTAO (CD_CTR_PONTOS,CD_EMP,CD_FILIAL,CD_VD,CD_IT)
			SELECT
				   SCOPE_IDENTITY()
				 , @CD_EMP
				 , @CD_FILIAL
				 , @CD_VD
				 , @CD_IT;
			
			FETCH NEXT FROM GerarPontos INTO  @CD_EMP,@CD_FILIAL,@CD_CLI,@QTDE_PONTOS,@DT_CAD,@CD_USU, @CD_VD, @CD_IT
		   
		END

		CLOSE GerarPontos;
		DEALLOCATE GerarPontos;
	END	

	/*****************************************************************************************************************************/
	/*****************************************************************************************************************************/	  
	/* INSERINDO DEBITOS */
	/*****************************************************************************************************************************/
	/*****************************************************************************************************************************/

	IF EXISTS (SELECT *
					FROM
						 PDV_VD p
						 INNER JOIN INSERTED i ON p.CD_EMP = i.CD_EMP
												  AND p.CD_FILIAL = i.CD_FILIAL
												  AND p.CD_VD = i.CD_VD						
					WHERE P.CD_EMP = 1
						  AND P.VD_TROCA_FIDEL = 1)
	BEGIN
	
		DECLARE GerarDebitos CURSOR FAST_FORWARD FOR 
		SELECT  v.CD_EMP
			  , V.CD_FILIAL
			  , V.CD_CLI
			  , i.VLR_PONTO_IT
			  , v.DT_VD
			  , v.CD_USU
			  , v.CD_VD
			  , it.CD_IT
			FROM 
				INSERTED i 
				INNER JOIN PDV_VD v ON 
					i.CD_EMP      = v.CD_EMP AND 
					i.CD_FILIAL   = v.CD_FILIAL AND 
					i.CD_VD       = v.CD_VD AND
					i.ENVIO_FIDEL = 0
				INNER JOIN PDV_VD_IT it ON 
					it.CD_EMP    = i.CD_EMP AND 
					it.CD_FILIAL = i.CD_FILIAL AND 
					it.CD_VD     = i.CD_VD AND
					it.CD_IT     = i.CD_IT 
			WHERE v.CD_EMP = 1
					AND V.VD_TROCA_FIDEL = 1;

		OPEN GerarDebitos
		FETCH NEXT FROM GerarDebitos INTO @CD_EMP, @CD_FILIAL, @CD_CLI, @QTDE_PONTOS, @DT_CAD, @CD_USU,  @CD_VD, @CD_IT;

		WHILE @@FETCH_STATUS = 0 
		BEGIN

			INSERT INTO RC_CLI_FIDELI_PONTOS_DEBITO (CD_EMP, CD_CLI, QTDE_PONTOS, DT_CAD, CD_USU, CD_MT_PONTO,APP_NAME)
			SELECT
				   @CD_EMP
				 , @CD_CLI
				 , @QTDE_PONTOS
				 , @DT_CAD
				 , @CD_USU
				 , 11 AS CD_MT_PONTO
				 , 'TRG_PDV_VD_IT_FIDELI_CARTAO';

			INSERT INTO  RC_CLI_FIDELI_PONTOS_DEBITO_PDV_VD_IT_FIDELI_CARTAO (CD_CTR_PONTOS,CD_EMP,CD_FILIAL,CD_VD,CD_IT)
			SELECT
				   SCOPE_IDENTITY()
				 , @CD_EMP
				 , @CD_FILIAL
				 , @CD_VD
				 , @CD_IT;

			FETCH NEXT FROM GerarDebitos INTO  @CD_EMP, @CD_FILIAL,@CD_CLI, @QTDE_PONTOS, @DT_CAD, @CD_USU,  @CD_VD,  @CD_IT

		END;
		
		CLOSE GerarDebitos;
		DEALLOCATE GerarDebitos;
	END;
	

	/*****************************************************************************************************************************/	 

END TRY
BEGIN CATCH
	IF @@NESTLEVEL > 0
		DECLARE @erro VARCHAR(500) = ERROR_MESSAGE();

	INSERT INTO ADM_ERRO( numero     , severidade     , estado     , rotina
							, linha     , mensagem     , dtErro)
       SELECT
              ERROR_NUMBER() AS numero
            , ERROR_SEVERITY() AS severidade
            , ERROR_STATE() AS estado
            , ERROR_PROCEDURE() AS rotina
            , ERROR_LINE() AS linha
            , ERROR_MESSAGE() AS mensagem
            , GETDATE() AS dtErro;

	RAISERROR(@erro, 16, 1);
END CATCH
END
